//
//  GSXMLWriter.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

int hexStringToInt(NSString *String);
NSString *hexStr(NSData *data, int spaceing);

/**
 Helper for writing XML
 has to be initialized with path to where XML file should be written
*/
@interface GSXMLWriter : NSObject {
	NSXMLElement *_root;
	NSMutableArray *_stack;
	FILE *_file;
	const char *_indentWhite;
	NSUInteger _indentlevel;
	BOOL _needIndent;
	BOOL _disableComments;
}

@property () BOOL disableComments;

- (id)initWithPath:(NSString *)path;
- (id)initWithPath:(NSString *)path indentWhite:(NSString *)indentWhite /*idleFunc=None,*/ encoding:(NSString *)encoding;

- (void)close;
- (void)write:(NSString *)data;
- (void)write8bitString:(NSString *)data;
- (void)write16bitString:(NSString *)data;
- (void)writecdata:(NSString *)string;
- (void)newline;
- (void)comment:(NSString *)data;
- (void)simpletag:(NSString *)_TAG_ args:(id)args;
- (void)begintag:(NSString *)_TAG_ args:(id)args;
- (void)endtag:(NSString *)_TAG_;
- (void)dumphex:(NSData *)data;
- (void)indent;
- (void)dedent;
- (NSString *)stringifyattrs:(id)args;

@end
